
// -----------------------------------------------------------------------------------------
//                      M A T E R I A L S
//------------------------------------------------------------------------------------------

#declare C_rust_red =       color rgb  <0.6, 0.3, 0.25>      ;
#declare C_rust_red_film =  color rgbt <0.6, 0.3, 0.25,.5>   ;
#declare C_rust_gray =      color rgb  <0.80, 0.80, 0.85>    ;
#declare C_rust_gray_dark = color rgb  <0.70, 0.70, 0.80>    ; 
#declare C_clear  =         rgbt 1                           ; 
#declare C_white =          color rgb<1,1,1>  ;
#declare C_gray50 =         color red 0.5 green 0.5 blue 0.5;  
#declare C_gray70 =         color red 0.7 green 0.7 blue 0.7; 

//--- steel old
#declare sz = <.1,2,.1> ;   
#declare turb = 1.1; 
#declare bump = .03; 

#declare T_metal_steel_old =
texture { 
    pigment { 
        spotted 
        color_map {
            [0.0        C_rust_gray]
            [0.1        C_rust_gray_dark]
            [0.3        C_rust_gray_dark * .9] 
            [0.55       C_rust_gray * 1.5]
            [0.85       C_rust_gray * 1.5]
            [0.9        C_rust_gray_dark]
            [1.000      C_rust_gray]
        }
        turbulence turb
        scale sz
    } 

    finish {  
        reflection {.001, .2 fresnel on } 
        conserve_energy 
        brilliance 5
        ambient 0
        brilliance 5
        diffuse 1 
        phong 1.5    
        phong_size 20
        metallic
        specular 3 
        roughness .01
        reflection .2 
    }
    
    normal {
         crackle 
         turbulence turb 
         bump_size bump
         scale sz
     }   
 }
 


//--- steel old spotted 
#declare sz = <1,1,1>*.5 ;   
#declare turb = 1.1; 
#declare bump = .2; 

#declare T_metal_steel_spotted =
texture { 
    pigment { 
        spotted 
        color_map {
            [0.0        C_clear              ]
            [0.2        C_rust_red           ]
            [0.3        C_rust_red_film * .7 ] 
            [0.4        C_clear              ]
            [0.85       C_clear              ]
            [0.9        C_rust_red_film * .6 ]
            [1.000      C_clear              ]
        } 
        turbulence turb
        scale sz
        } 

    finish {  
        reflection {.001, .2 fresnel on } 
        conserve_energy 
        brilliance 5
        ambient 0
        brilliance 5
        diffuse 1 
        phong 1.5    
        phong_size 20
        metallic
        specular 3 
        roughness .01
        reflection .2 
    }
    
    normal {
        pigment_pattern{ 
            spotted 
            color_map {
                [0.0        C_white  ]
                [0.2        C_gray50 ]
                [0.3        C_gray70 ] 
                [0.4        C_white  ]
                [0.85       C_white  ]
                [0.9        C_gray50 ]
                [1.000      C_white  ]
            } 
            turbulence turb
            scale sz
         }  
         bump_size bump
     }   
 }




//--- steel aged
#declare M_steel_aged =
material {
   texture { T_metal_steel_old }
   texture { T_metal_steel_spotted scale <1.5,2.5,1.5>}
}
